## Example Summary

Example that uses the GPIO and UART driver to program an MSP430 FLASH based device.

## Peripherals Exercised

* `UART4` - Used to send BSL commands to the target MSP430 device
* `RESET_PIN` - Used to control the reset pin of the target MSP430 device
* `TEST_PIN` - Used to control the test pin of the target MSP430 device

## Example Usage

To configure the BeagleBone pins for GPIO usage, you must run the following commands:

* config-pin P9.14 gpio
* config-pin P9.16 gpio

To configure the BeagleBone pins for uart usage, you must run the following commands:

* config-pin P9.11 uart
* config-pin P9.13 uart

## Connections

* Connect the RESET_PIN (P9_14: GPIO1_18) to the reset pin of the target device (MSP430G2553 rst pin used for testing)
* Connect the TEST_PIN (P9_16: GPIO1_19) to the test pin of the target device (MSP430G2553 test pin used for testing)
* Connect the UART4_RXD (P9_11) to the BSL Transmit pin of the target device (MSP430G2553 P1.1 pin used for testing)
* Connect the UART4_TXD (P9_13) to the BSL Receive pin of the target device (MSP430G2553 P1.5 pin used for testing)

* The BeagleBone Host begins to program the target MSP430 with the blinky image. The target MSP430 image is located in image/msp430_image.h

BeagleBone Image:

* The BeagleBone image used in this project can be found at,
https://debian.beagleboard.org/images/bone-debian-8.6-iot-armhf-2016-12-09-4gb.img.xz
